/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#include "Filter_Safari.h"

/*Safari Filter bevat 3 filters. Twee die zoekt naar URLS en een die zoekt naar Cookies, de filters staan beschreven in "5. Safari".
Filter 1: URL's, beschreven in "Header 2"
Filter 2: URL's, beschreven in "Header 3"
Filter 3: cookies, beschreven in "5.2 Cookies" */

/*--------------------------------------------------------Filter 1--------------------------------------------------------*/
DUMP_SESSION* InitiateSafariFilter1(char* location, char* argument, int analyse_type) {
		return CreateMemoryDump(location, "Safari_URL_Search_Header2.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt alle URL's in Safari door te zoeken naar de bytecode waarmee een string begint.*/
int ApplySafariFilter1(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	char signature[7]={0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; //Soort handtekening van bezochte URL's in Safari
	char* moveBuff=buff;	//Positie in het geheugen waar de filter op dit moment bezig is
	char* moveBuff2;		//Zelfde als moveBuff, echter  wordt op deze manier de orginele positie behouden
	int writtenBytes;		//Returnvalue van Writefile()
	int readSize=0;			//Tijdelijke parameter waar de grote van de string op wordt geplaatst.
	int URLcheckPos=0;		//Hierop wordt bijgehouden of we de grote van de string niet overschrijden met het analyseren van het geheugen
	int isOkayURL;			//Boolean waarde die Waar is indien de string een URL is en Onwaar indien de string geen URL bevat.
	int foundDot;			//Boolean waarde, waar indien een punt is gevonden in de string, Onwaar indien er geen punt in voor komt
	

	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			
			if(memcmp(moveBuff, signature, 7) == 0) { //Controleer op de handtekeninge van URL's
				moveBuff+=7; //Zet pointer op de lengte van de string
				readSize = (int) *(int*)moveBuff; //Lees de lengte uit
				moveBuff+=4+4; //Zet de pointer op de string

				isOkayURL = 1;
				foundDot=0;
				moveBuff2= moveBuff;

				URLcheckPos = readSize;

				/*Controleer of het domein en het hiervoorstaande protocol voldoet aan de eisen en bestaat uit:
				- Letters a - z
				- Cijfers 0-9
				- '-' of '.' */
				while(*moveBuff2 != 0 && URLcheckPos!=0) {
					if((*moveBuff2 < 'a' || *moveBuff2 > 'z') 
					&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
					&& *moveBuff2 != '-'
					&& *moveBuff2 != '.') {
						if(*moveBuff2 == ':' && *(moveBuff2+1) == '/' && *(moveBuff2+2) == '/') {
							//"://" is het einde van een protocolnaam, hierna komt de domeinnaam
							moveBuff2+=2;
						} else {
							if(*moveBuff2 == '/') //Hier loopt het domein af en begint de URL
								break;
							isOkayURL = 0;
							break;
						}
					} else {
						if(*moveBuff2 == '.')
							foundDot=1;
					}

					moveBuff2++;
					URLcheckPos--;
				}

				/*Je verwacht een punt in de domeinnaam (bijvoorbeeld .nl / .com / .net)*/
				if(foundDot==0)
					isOkayURL = 0;

				/*Controleer of de URL voldoet:
				- mag niet bestaan uit spatie (deze wordt immers aangeduid als %20)
				-Mag niet bestaan uit een nieuwelijn (0D of 0A)
				*/
				while(*moveBuff2 != 0 && URLcheckPos!=0) {
					if(*moveBuff2 == ' ' || *moveBuff2 == 0x0D || *moveBuff2 == 0x0A) {
						isOkayURL = 0;
						break;
					}
					moveBuff2++;
					URLcheckPos--;
				}

				if(isOkayURL && URLcheckPos==0) {
					/*Schrijf het adres weg waar de string gevonden is, indien nodig*/
					if(dmp->flags&DS_WRITE_LOCATION_STRING) {
						printf("Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
						sprintf(dmp->string_location, "Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
						WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
					}

					//Schrijf de gevonden URL weg
					printf("%s\n", moveBuff);
					WriteFile(dmp->dumpFile, moveBuff, readSize, (LPDWORD) &writtenBytes, NULL);
					WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

					//Verschuif de buffer om verder te zoeken
					moveBuff += readSize -1;
				} else {
					moveBuff -= 7+4+4;
				}
			}
		}				
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}

	return 0;
}

void DestroySafariFilter1(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter 1-----------------------------------------------------*/

/*--------------------------------------------------------Filter 2--------------------------------------------------------*/
DUMP_SESSION* InitiateSafariFilter2(char* location, char* argument, int analyse_type) {
		return CreateUNICODEMemoryDump(location, "Safari_URL_Search_Header3.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt alle URL's in Safari door te zoeken naar de bytecode waarmee een string begint.*/
int ApplySafariFilter2(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	/*Signature1 bvat de string "URL"*/
	char signature1[10]={0x00, 0x55, 0x00, 0x52, 0x00, 0x4C, 0x00, 0x00, 0x00, 0x10}; 
	/*Signature1 bvat de string "Link"*/
	char signature2[7] = {0x4C, 0x00, 0x69, 0x00, 0x6E, 0x00, 0x6B};


	char* moveBuff=buff;		//Positie in het geheugen waar de filter op dit moment bezig is
	wchar_t* moveBuff2;			//Zelfde als moveBuff, echter  wordt op deze manier de orginele positie behouden
	int writtenBytes;			//Returnvalue van Writefile()
	int readSize=0;				//Tijdelijke parameter waar de grote van de string op wordt geplaatst.
	int readSizeinUnicode=0;	//Tijdelijke parameter waar aantal caracters van een unicodestring op wordt geplaatst


	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			if(memcmp(moveBuff, signature1, 10) == 0
				&& memcmp(moveBuff-7, signature2, 7) != 0) {
				
				moveBuff+=10+3; //Zet pointer op de lengte van de string
				readSizeinUnicode = *(int*)moveBuff; //Lees de lengte uit in bytes
				moveBuff+=4; 
				readSize = *(int*)moveBuff; //Lees de lengte uit in bytes*2
				moveBuff+=4+4; //Zet de pointer op de string*/
				

				if(readSize/2 == readSizeinUnicode	&& readSize != 0) {  

						/*Schrijf het adres weg waar de string gevonden is, indien nodig*/
						if(dmp->flags&DS_WRITE_LOCATION_STRING) {
							printf("Address: %p: ",(memlong) memInfo->BaseAddress + (moveBuff - buff));
							wsprintfW((LPWSTR) dmp->string_location, L"Address: %p, \0", (memlong) memInfo->BaseAddress + (moveBuff - buff));
							WriteFile(dmp->dumpFile, dmp->string_location, wcslen((wchar_t*) dmp->string_location)*2, (LPDWORD) &writtenBytes, NULL);
						}

						wprintf(L"%s\r\n", moveBuff);
						WriteFile(dmp->dumpFile, moveBuff, readSize, (LPDWORD) &writtenBytes, NULL);
						WriteFile(dmp->dumpFile, L"\r\n", 4, (LPDWORD) &writtenBytes, NULL);


						//Verschuif de buffer om verder te zoeken
						moveBuff += readSize -1;
					//}

				} else {
					moveBuff -= 10+3+4+4+4;
				}
			}
		}				
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}

	return 0;
}

void DestroySafariFilter2(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter 2-----------------------------------------------------*/


/*--------------------------------------------------------Filter 3--------------------------------------------------------*/
DUMP_SESSION* InitiateSafariFilter3(char* location, char* argument, int analyse_type) {
		return CreateMemoryDump(location, "Safari_Cookie_Search.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt alle URL's in Safari door te zoeken naar de bytecode waarmee een string begint.*/
int ApplySafariFilter3(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	/*In signature1 staat de string 

		"Set-Cookie"

	hier begint elke cookie mee in Safari
	*/
	char signature1[10]={0x53, 0x65, 0x74, 0x2D, 0x43, 0x6F, 0x6F, 0x6B, 0x69, 0x65};
	/*Hierna komt 6 onbekende random byte*/
	/*In signature2 staat de string met bytes die na "Set cookie" komen en na de onbekende random byte

		"Set-Cookie"

	hier begint elke cookie mee in Safari
	*/
	//char signature2[21]={0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	char signature2[16]={0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	/*Hierna komen 4 bytes met de groote van de string die de cookie bevat*/
	/*Hierna komen nog 4 lege bytes waarna de string komt*/
	char signature3[4]={0x00, 0x00, 0x00, 0x00};

	/*Deze string wordt gebruikt om de URL te zoeken, deze string ergens boven de gevonden cookie*/
	char signature4[7]={0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	/*Hiertussen komt de grootte van de string*/
	/*Dit staat na de grootte van de string*/
	char signature5[8]={0x00, 0x00, 0x00, 0x00, 0x68, 0x74, 0x74, 0x70};

	char* moveBuff=buff; //Positie in het geheugen waar de filter op dit moment bezig is
	char* moveBuff2;     //Zelfde als moveBuff, echter  wordt op deze manier de orginele positie behouden
	int writtenBytes;	 //Returnvalue van Writefile()
	int readSize=0;		 //Tijdelijke parameter waar de grote van de string op wordt geplaatst.
	int readSize_tmp;
	int readSize_tmp2;
	int url_size;
	int i;

	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			readSize = * ((int*) (moveBuff + 10+6+16));

			if(	memcmp(moveBuff, signature1,  9) == 0
			&& memcmp(moveBuff+10+6, signature2,  16) == 0
			&& memcmp(moveBuff+10+6+16+4, signature3,  4) == 0
			) { //We willen alleen adressen die beginnen met "Set-Cookie" en de andere bytes-set die erachter komen
				moveBuff2 = moveBuff;

				/*In de onderstaande loop gaan we op zoek in het geheugen naar de URL die deze cookie geplaatst heeft*/
				while(moveBuff2 != (buff+overflowSize)) {
					if(memcmp(moveBuff2, signature5, 8) == 0
					&& memcmp(moveBuff2-4-7, signature4, 7) == 0
					) {
						url_size = * ((int*) (moveBuff2 - 4));
						i = url_size;
						while(i!=0) {
							if(*(moveBuff2+i) == ' ')
								break;

							i--;
						}

						if(i==0) {
							moveBuff2 += 4;
							break;
						}
					}
					moveBuff2++;
				}

				//Staat de URL aan het eind van het geheugen, dan is het geen URL
				if(moveBuff2 == (buff+overflowSize))
					moveBuff2 = 0;
				
				/*Schrijf het adres weg waar de URL gevonden is, indien nodig*/
				if(dmp->flags&DS_WRITE_LOCATION_STRING) {
					printf("Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
					sprintf(dmp->string_location, "Address: %p: \r\n", (memlong) memInfo->BaseAddress + (moveBuff - buff));
					WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
				}				

				if(moveBuff2) {
					//Schrijf de URL weg
					WriteFile(dmp->dumpFile, "Geplaatst door: ", strlen("Geplaatst door: "), (LPDWORD) &writtenBytes, NULL);
					WriteFile(dmp->dumpFile, moveBuff2, url_size, (LPDWORD) &writtenBytes, NULL);
				}

				moveBuff += 10+6+16+4+4; //Sla de gecontroleerde byte-set over

				//Schrijf de gevonden cookie(s) weg
				readSize_tmp = readSize;

				/*Lopp door alle cookies in de string*/
				while(readSize_tmp!=0) {
					readSize_tmp2 = 0;

					/*Als er een nieuwe cookie gevonden is, schrijf dan opnieuw het adres en geplaatste URL weg.*/
					if(*(moveBuff-1) == ',' && *(moveBuff-5) != '=' && *(moveBuff)==' ') {
						moveBuff++;
						readSize_tmp--;

						WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

						/*Schrijf het adres weg waar de cookie gevonden is, indien nodig*/
						if(dmp->flags&DS_WRITE_LOCATION_STRING) {
							printf("Address: %p: \r\n", (memlong) memInfo->BaseAddress + (moveBuff - buff));
							sprintf(dmp->string_location, "\r\nAddress: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
							WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
						}
						
						if(moveBuff2) {
							//Schrijf de URL weg
							WriteFile(dmp->dumpFile, "\r\nGeplaatst door: ", strlen("\r\nGeplaatst door: "), (LPDWORD) &writtenBytes, NULL);
							WriteFile(dmp->dumpFile, moveBuff2, url_size, (LPDWORD) &writtenBytes, NULL);
							//WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);
						}
						
					}

					/*Zoek het einde van een eigenschap*/
					while(*(moveBuff+readSize_tmp2)!=';' && 
						!(
							*(moveBuff+readSize_tmp2)==',' 
							&& *(moveBuff+readSize_tmp2-4) != '=' 
							&& *(moveBuff+readSize_tmp2+1)==' '
						) 
						&& readSize_tmp!=0) {
						readSize_tmp2++;
						readSize_tmp--;
					}

					/*Schrijf de eigenschap van de cookie weg*/
					WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);
					if(*moveBuff==' ')
						WriteFile(dmp->dumpFile, moveBuff+1, readSize_tmp2-1, (LPDWORD) &writtenBytes, NULL);
					else
						WriteFile(dmp->dumpFile, moveBuff, readSize_tmp2, (LPDWORD) &writtenBytes, NULL);

					moveBuff += readSize_tmp2+1;
					if(readSize_tmp) readSize_tmp--;
				}

				WriteFile(dmp->dumpFile, "\r\n\r\n", strlen("\r\n\r\n"), (LPDWORD) &writtenBytes, NULL);

				//Verschuif de buffer om verder te zoeken
				moveBuff -= 2;
			}
		}
		//}				
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}

	return 0;
}

void DestroySafariFilter3(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter 3-----------------------------------------------------*/

